/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.navigation;

import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class NavigationUtils {
    private NavigationUtils() {
        throw new UnsupportedOperationException("NavigationUtils only contains static definitions.");
    }

    public static <E extends SpruceWidget> boolean tryNavigate(NavigationDirection direction, boolean tab, List<E> children, E focused, Consumer<E> setFocused, boolean alwaysFocus) {
        int i;
        if (children.isEmpty()) {
            return false;
        }
        if (!tab && alwaysFocus && focused != null) {
            i = children.indexOf(focused);
            if (!direction.isLookingForward() && i == 0 || direction.isLookingForward() && i == children.size() - 1) {
                boolean result = focused.onNavigation(direction, false);
                focused.setFocused(true);
                return result;
            }
        }
        if (focused == null || !focused.onNavigation(direction, tab)) {
            SpruceWidget nextElement;
            Supplier<SpruceWidget> nextGetter;
            BooleanSupplier hasNext;
            i = children.indexOf(focused);
            int next = focused != null && i >= 0 ? i + (direction.isLookingForward() ? 1 : 0) : (direction.isLookingForward() ? 0 : children.size());
            ListIterator<E> iterator = children.listIterator(next);
            BooleanSupplier booleanSupplier = direction.isLookingForward() ? iterator::hasNext : (hasNext = iterator::hasPrevious);
            Supplier<SpruceWidget> supplier = direction.isLookingForward() ? iterator::next : (nextGetter = iterator::previous);
            do {
                if (hasNext.getAsBoolean()) continue;
                setFocused.accept(null);
                return false;
            } while (!(nextElement = nextGetter.get()).onNavigation(direction, tab));
            setFocused.accept(nextElement);
        }
        return true;
    }
}

